import { defineIntegration, normalize } from '@sentry/core';
import { addScopeListener } from '../../common/scope.js';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup() {
            const ipc = getIPC();
            addScopeListener((merged, changed) => {
                ipc.sendScope(JSON.stringify(normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

export { scopeToMainIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/fe5d1728063e86edeeda5bebd2c8e14bf4d0f960/node_modules/@sentry/electron/esm/renderer/integrations/scope-to-main.js.map
