import { executeSchedule } from '../util/executeSchedule.js';
import { Observable, operate } from '../Observable.js';
export function observeOn(scheduler, delay = 0) {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => executeSchedule(destination, scheduler, () => destination.next(value), delay),
            error: (err) => executeSchedule(destination, scheduler, () => destination.error(err), delay),
            complete: () => executeSchedule(destination, scheduler, () => destination.complete(), delay),
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/f6a8593b2b7c61c2063c79d5a8fcd248c9db4580/node_modules/rxjs/dist/esm/internal/operators/observeOn.js.map