import { makeOfflineTransport } from '@sentry/core';
import { makeElectronTransport } from './electron-net.js';
import { createOfflineStore } from './offline-store.js';

/**
 * Creates a Transport that uses Electrons net module to send events to Sentry. When they fail to send they are
 * persisted to disk and sent later
 */
function makeElectronOfflineTransport(baseTransport = makeElectronTransport) {
    return (userOptions) => {
        // `makeElectronOfflineTransport` is a combination of two transports.
        //
        // The base Electron transport (`makeElectronTransport`) is wrapped by `makeOfflineTransport` which stores events to
        // disk when they fail to send.
        return makeOfflineTransport(baseTransport)({
            flushAtStartup: true,
            createStore: createOfflineStore,
            ...userOptions,
        });
    };
}

export { makeElectronOfflineTransport };//# sourceMappingURL=http://go/sourcemap/sourcemaps/f6a8593b2b7c61c2063c79d5a8fcd248c9db4580/node_modules/@sentry/electron/esm/main/transports/electron-offline-net.js.map
