import { chromeStackLineParser } from '@sentry/browser';
import { nodeStackLineParser, stripSentryFramesAndReverse } from '@sentry/core';

const STACKTRACE_FRAME_LIMIT = 50;
const [, chrome] = chromeStackLineParser;
const [, node] = nodeStackLineParser();
/**
 * A stack parser than combines Chrome and node.js parsers to give the best results even when nodeIntegration = true
 */
const electronRendererStackParser = (stack, skipFirst = 0) => {
    const frames = [];
    for (const line of stack.split('\n').slice(skipFirst)) {
        const chromeFrame = chrome(line);
        const nodeFrame = node(line);
        // We favour the chrome parser unless in_app == false
        if (chromeFrame && nodeFrame?.in_app !== false) {
            frames.push(chromeFrame);
        }
        else if (nodeFrame) {
            if (nodeFrame.module === undefined) {
                delete nodeFrame.module;
            }
            frames.push(nodeFrame);
        }
        if (frames.length >= STACKTRACE_FRAME_LIMIT) {
            break;
        }
    }
    return stripSentryFramesAndReverse(frames);
};

export { electronRendererStackParser };//# sourceMappingURL=http://go/sourcemap/sourcemaps/f6a8593b2b7c61c2063c79d5a8fcd248c9db4580/node_modules/@sentry/electron/esm/renderer/stack-parse.js.map
