import { AsyncScheduler } from './AsyncScheduler.js';
export class AsapScheduler extends AsyncScheduler {
    flush(action) {
        this._active = true;
        const flushId = this._scheduled;
        this._scheduled = undefined;
        const { actions } = this;
        let error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/f628a4761be40b8869ca61a6189cafd14756dff0/node_modules/rxjs/dist/esm/internal/scheduler/AsapScheduler.js.map