Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const api = require('@opentelemetry/api');
const opentelemetry = require('@sentry/opentelemetry');

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = opentelemetry.getScopesFromContext(api.context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

exports.setIsolationScope = setIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/f5edf5b2fdaaf0f44d324fa092a32515ce114c90/node_modules/@sentry/node-core/build/cjs/sdk/scope.js.map
