const core = require('@sentry/core');
const ipc = require('./ipc.js');

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    let ipc$1;
    return core.createTransport(options, async (request) => {
        // We delay getting the IPC interface until until there is a client where we can pull the IPC namespace from.
        if (!ipc$1) {
            ipc$1 = ipc.getIPC();
        }
        ipc$1.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    });
}

exports.makeRendererTransport = makeRendererTransport;//# sourceMappingURL=http://go/sourcemap/sourcemaps/f5edf5b2fdaaf0f44d324fa092a32515ce114c90/node_modules/@sentry/electron/renderer/transport.js.map
