"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.take = void 0;
const empty_js_1 = require("../observable/empty.js");
const Observable_js_1 = require("../Observable.js");
function take(count) {
    return count <= 0
        ?
            () => empty_js_1.EMPTY
        : (source) => new Observable_js_1.Observable((destination) => {
            let seen = 0;
            const operatorSubscriber = (0, Observable_js_1.operate)({
                destination,
                next: (value) => {
                    if (++seen < count) {
                        destination.next(value);
                    }
                    else {
                        operatorSubscriber.unsubscribe();
                        destination.next(value);
                        destination.complete();
                    }
                },
            });
            source.subscribe(operatorSubscriber);
        });
}
exports.take = take;//# sourceMappingURL=http://go/sourcemap/sourcemaps/f5edf5b2fdaaf0f44d324fa092a32515ce114c90/node_modules/rxjs/dist/cjs/internal/operators/take.js.map