"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultIfEmpty = void 0;
const Observable_js_1 = require("../Observable.js");
function defaultIfEmpty(defaultValue) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}
exports.defaultIfEmpty = defaultIfEmpty;//# sourceMappingURL=http://go/sourcemap/sourcemaps/f5edf5b2fdaaf0f44d324fa092a32515ce114c90/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js.map