let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

export { isDebuggerEnabled };//# sourceMappingURL=http://go/sourcemap/sourcemaps/f5edf5b2fdaaf0f44d324fa092a32515ce114c90/node_modules/@sentry/node-core/build/esm/utils/debug.js.map
