const electron = require('electron');

/** Ways to communicate between the renderer and main process  */
var IPCMode;
(function (IPCMode) {
    /** Configures Electron IPC to receive messages from renderers */
    IPCMode[IPCMode["Classic"] = 1] = "Classic";
    /** Configures Electron protocol module to receive messages from renderers */
    IPCMode[IPCMode["Protocol"] = 2] = "Protocol";
    /**
     * Configures both methods for best compatibility.
     *
     * Renderers favour IPC but fall back to protocol if IPC has not
     * been configured in a preload script
     */
    IPCMode[IPCMode["Both"] = 3] = "Both";
})(IPCMode || (IPCMode = {}));
var IPCChannel;
(function (IPCChannel) {
    /** IPC to check main process is listening */
    IPCChannel["RENDERER_START"] = "sentry-electron.renderer-start";
    /** IPC to pass scope changes to main process. */
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    /** IPC to pass envelopes to the main process. */
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
    /** IPC to pass renderer status updates */
    IPCChannel["STATUS"] = "sentry-electron.status";
    /** IPC to pass structured log messages */
    IPCChannel["STRUCTURED_LOG"] = "sentry-electron.structured-log";
})(IPCChannel || (IPCChannel = {}));

/**
 * This preload script may be used with sandbox mode enabled which means regular require is not available.
 */
// eslint-disable-next-line no-restricted-globals
if (window.__SENTRY_IPC__) {
    // eslint-disable-next-line no-console
    console.log('Sentry Electron preload has already been run');
}
else {
    const ipcObject = {
        sendRendererStart: () => electron.ipcRenderer.send(IPCChannel.RENDERER_START),
        sendScope: (scopeJson) => electron.ipcRenderer.send(IPCChannel.SCOPE, scopeJson),
        sendEnvelope: (envelope) => electron.ipcRenderer.send(IPCChannel.ENVELOPE, envelope),
        sendStatus: (status) => electron.ipcRenderer.send(IPCChannel.STATUS, status),
        sendStructuredLog: (log) => electron.ipcRenderer.send(IPCChannel.STRUCTURED_LOG, log),
    };
    // eslint-disable-next-line no-restricted-globals
    window.__SENTRY_IPC__ = ipcObject;
    // We attempt to use contextBridge if it's available
    if (electron.contextBridge) {
        // This will fail if contextIsolation is not enabled
        try {
            electron.contextBridge.exposeInMainWorld('__SENTRY_IPC__', ipcObject);
        }
        catch (e) {
            //
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/efc470092d04e891b9b7c8d5386bd5634fc7efe0/node_modules/@sentry/electron/preload/index.js.map
