function addHeader(responseHeaders = {}, name, value) {
    if (responseHeaders[name]) {
        const existing = responseHeaders[name];
        if (Array.isArray(existing)) {
            existing.push(value);
        }
        else {
            responseHeaders[name] = [existing, value];
        }
    }
    else {
        responseHeaders[name] = value;
    }
    return { responseHeaders };
}
/**
 * Adds a header to a session's web request
 */
function addHeaderToSession(sesh, header, value) {
    sesh.webRequest.onHeadersReceived((details, callback) => {
        callback(addHeader(details.responseHeaders, header, value));
    });
}

exports.addHeaderToSession = addHeaderToSession;//# sourceMappingURL=http://go/sourcemap/sourcemaps/efc470092d04e891b9b7c8d5386bd5634fc7efe0/node_modules/@sentry/electron/main/header-injection.js.map
