const core = require('@sentry/core');
const ipc = require('./ipc.js');

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    const ipc$1 = ipc.getIPC();
    return core.createTransport(options, async (request) => {
        ipc$1.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    });
}

exports.makeRendererTransport = makeRendererTransport;//# sourceMappingURL=http://go/sourcemap/sourcemaps/efc470092d04e891b9b7c8d5386bd5634fc7efe0/node_modules/@sentry/electron/renderer/transport.js.map
