const electron = require('electron');
const ipc = require('../common/ipc.js');

/**
 * This preload script may be used with sandbox mode enabled which means regular require is not available.
 */
/**
 * Hook up IPC to the window object and uses contextBridge if available.
 *
 * @param namespace An optional namespace to use for the IPC channels
 */
function hookupIpc(namespace = 'sentry-ipc') {
    const ipcUtil = ipc.ipcChannelUtils(namespace);
    // eslint-disable-next-line no-restricted-globals
    window.__SENTRY_IPC__ = window.__SENTRY_IPC__ || {};
    // eslint-disable-next-line no-restricted-globals
    if (window.__SENTRY_IPC__[ipcUtil.namespace]) {
        // eslint-disable-next-line no-console
        console.log('Sentry Electron preload has already been run');
    }
    else {
        const ipcObject = {
            sendRendererStart: () => electron.ipcRenderer.send(ipcUtil.createKey('start')),
            sendScope: (scopeJson) => electron.ipcRenderer.send(ipcUtil.createKey('scope'), scopeJson),
            sendEnvelope: (envelope) => electron.ipcRenderer.send(ipcUtil.createKey('envelope'), envelope),
            sendStatus: (status) => electron.ipcRenderer.send(ipcUtil.createKey('status'), status),
            sendStructuredLog: (log) => electron.ipcRenderer.send(ipcUtil.createKey('structured-log'), log),
        };
        // eslint-disable-next-line no-restricted-globals
        window.__SENTRY_IPC__[ipcUtil.namespace] = ipcObject;
        // We attempt to use contextBridge if it's available
        if (electron.contextBridge) {
            // This will fail if contextIsolation is not enabled
            try {
                // eslint-disable-next-line no-restricted-globals
                electron.contextBridge.exposeInMainWorld('__SENTRY_IPC__', window.__SENTRY_IPC__);
            }
            catch (e) {
                //
            }
        }
    }
}

exports.hookupIpc = hookupIpc;//# sourceMappingURL=http://go/sourcemap/sourcemaps/eecab7538820b6470389330d2cca30b703322290/node_modules/@sentry/electron/preload/index.js.map
