const core = require('@sentry/core');
const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});

exports.mainProcessSessionIntegration = mainProcessSessionIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/eecab7538820b6470389330d2cca30b703322290/node_modules/@sentry/electron/main/integrations/main-process-session.js.map
