"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retry = void 0;
const Observable_js_1 = require("../Observable.js");
const identity_js_1 = require("../util/identity.js");
const timer_js_1 = require("../observable/timer.js");
function retry(configOrCount = Infinity) {
    let config;
    if (configOrCount && typeof configOrCount === 'object') {
        config = configOrCount;
    }
    else {
        config = {
            count: configOrCount,
        };
    }
    const { count = Infinity, delay, resetOnSuccess: resetOnSuccess = false } = config;
    return count <= 0
        ? identity_js_1.identity
        : (source) => new Observable_js_1.Observable((destination) => {
            let soFar = 0;
            let innerSub;
            const subscribeForRetry = () => {
                let syncUnsub = false;
                innerSub = source.subscribe((0, Observable_js_1.operate)({
                    destination,
                    next: (value) => {
                        if (resetOnSuccess) {
                            soFar = 0;
                        }
                        destination.next(value);
                    },
                    error: (err) => {
                        if (soFar++ < count) {
                            const resub = () => {
                                if (innerSub) {
                                    innerSub.unsubscribe();
                                    innerSub = null;
                                    subscribeForRetry();
                                }
                                else {
                                    syncUnsub = true;
                                }
                            };
                            if (delay != null) {
                                const notifier = typeof delay === 'number' ? (0, timer_js_1.timer)(delay) : (0, Observable_js_1.from)(delay(err, soFar));
                                const notifierSubscriber = (0, Observable_js_1.operate)({
                                    destination,
                                    next: () => {
                                        notifierSubscriber.unsubscribe();
                                        resub();
                                    },
                                    complete: () => {
                                        destination.complete();
                                    },
                                });
                                notifier.subscribe(notifierSubscriber);
                            }
                            else {
                                resub();
                            }
                        }
                        else {
                            destination.error(err);
                        }
                    },
                }));
                if (syncUnsub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    subscribeForRetry();
                }
            };
            subscribeForRetry();
        });
}
exports.retry = retry;//# sourceMappingURL=http://go/sourcemap/sourcemaps/e59189a34d286d2e1fd6985c9272738c54289860/node_modules/rxjs/dist/cjs/internal/operators/retry.js.map