import { forEachEnvelopeItem } from '@sentry/core';

/** Pulls an event and additional envelope items out of an envelope. Returns undefined if there was no event */
function eventFromEnvelope(envelope) {
    let event;
    const attachments = [];
    let profile;
    forEachEnvelopeItem(envelope, (item, type) => {
        if (type === 'event' || type === 'transaction' || type === 'feedback') {
            event = Array.isArray(item) ? item[1] : undefined;
        }
        else if (type === 'attachment') {
            const [headers, data] = item;
            attachments.push({
                filename: headers.filename,
                attachmentType: headers.attachment_type,
                contentType: headers.content_type,
                data,
            });
        }
        else if (type === 'profile') {
            profile = item[1];
        }
    });
    return event ? [event, attachments, profile] : undefined;
}

export { eventFromEnvelope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/e3fd5c7abddff43abcd46fd93c25e85145200ad0/node_modules/@sentry/electron/esm/common/envelope.js.map
