"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEventPattern = void 0;
const Observable_js_1 = require("../Observable.js");
const mapOneOrManyArgs_js_1 = require("../util/mapOneOrManyArgs.js");
function fromEventPattern(addHandler, removeHandler, resultSelector) {
    if (resultSelector) {
        return (0, mapOneOrManyArgs_js_1.mapOneOrManyArgs)(resultSelector)(fromEventPattern(addHandler, removeHandler));
    }
    return new Observable_js_1.Observable((subscriber) => {
        const handler = (...e) => subscriber.next(e.length === 1 ? e[0] : e);
        const retValue = addHandler(handler);
        return (0, Observable_js_1.isFunction)(removeHandler) ? () => removeHandler(handler, retValue) : undefined;
    });
}
exports.fromEventPattern = fromEventPattern;//# sourceMappingURL=http://go/sourcemap/sourcemaps/df371ac0d93fe1a68d05eeb59a09c5c39add0c80/node_modules/rxjs/dist/cjs/internal/observable/fromEventPattern.js.map