"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsapScheduler = void 0;
const AsyncScheduler_js_1 = require("./AsyncScheduler.js");
class AsapScheduler extends AsyncScheduler_js_1.AsyncScheduler {
    flush(action) {
        this._active = true;
        const flushId = this._scheduled;
        this._scheduled = undefined;
        const { actions } = this;
        let error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}
exports.AsapScheduler = AsapScheduler;//# sourceMappingURL=http://go/sourcemap/sourcemaps/df371ac0d93fe1a68d05eeb59a09c5c39add0c80/node_modules/rxjs/dist/cjs/internal/scheduler/AsapScheduler.js.map