import { createTransport } from '@sentry/core';
import { getIPC } from './ipc.js';

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    const ipc = getIPC();
    return createTransport(options, async (request) => {
        ipc.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    });
}

export { makeRendererTransport };//# sourceMappingURL=http://go/sourcemap/sourcemaps/df279210b53cf4686036054b15400aa2fe06d6d0/node_modules/@sentry/electron/esm/renderer/transport.js.map
