import crypto from 'crypto';
import { coerce } from '../bytes.js';
import { from } from './hasher.js';
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: (input) => coerce(crypto.createHash('sha256').update(input).digest())
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: input => coerce(crypto.createHash('sha512').update(input).digest())
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/deaab40c3ffd3f2df9bcbb01301f9a9be3424170/node_modules/multiformats/dist/src/hashes/sha2.js.map