let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

export { isDebuggerEnabled };//# sourceMappingURL=http://go/sourcemap/sourcemaps/deaab40c3ffd3f2df9bcbb01301f9a9be3424170/node_modules/@sentry/node-core/build/esm/utils/debug.js.map
