export const intervalProvider = {
    setInterval(handler, timeout, ...args) {
        const { delegate } = intervalProvider;
        if (delegate?.setInterval) {
            return delegate.setInterval(handler, timeout, ...args);
        }
        return setInterval(handler, timeout, ...args);
    },
    clearInterval(handle) {
        const { delegate } = intervalProvider;
        return (delegate?.clearInterval || clearInterval)(handle);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/rxjs/dist/esm/internal/scheduler/intervalProvider.js.map