"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sample = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function sample(notifier) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
            },
        }));
        (0, Observable_js_1.from)(notifier).subscribe((0, Observable_js_1.operate)({
            destination,
            next: () => {
                if (hasValue) {
                    hasValue = false;
                    const value = lastValue;
                    lastValue = null;
                    destination.next(value);
                }
            },
            complete: noop_js_1.noop,
        }));
    });
}
exports.sample = sample;//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/rxjs/dist/cjs/internal/operators/sample.js.map