"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairwise = void 0;
const Observable_js_1 = require("../Observable.js");
function pairwise() {
    return (source) => new Observable_js_1.Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}
exports.pairwise = pairwise;//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js.map