const core = require('@sentry/core');
const scope = require('../../common/scope.js');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup(client) {
            const ipc$1 = ipc.getIPC(client);
            scope.addScopeListener((merged, changed) => {
                ipc$1.sendScope(JSON.stringify(core.normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

exports.scopeToMainIntegration = scopeToMainIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/@sentry/electron/renderer/integrations/scope-to-main.js.map
