"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnimationFrameAction = void 0;
const AsyncAction_js_1 = require("./AsyncAction.js");
const animationFrameProvider_js_1 = require("./animationFrameProvider.js");
class AnimationFrameAction extends AsyncAction_js_1.AsyncAction {
    scheduler;
    work;
    constructor(scheduler, work) {
        super(scheduler, work);
        this.scheduler = scheduler;
        this.work = work;
    }
    requestAsyncId(scheduler, id, delay = 0) {
        if (delay !== null && delay > 0) {
            return super.requestAsyncId(scheduler, id, delay);
        }
        scheduler.actions.push(this);
        return scheduler._scheduled || (scheduler._scheduled = animationFrameProvider_js_1.animationFrameProvider.requestAnimationFrame(() => scheduler.flush(undefined)));
    }
    recycleAsyncId(scheduler, id, delay = 0) {
        if (delay != null ? delay > 0 : this.delay > 0) {
            return super.recycleAsyncId(scheduler, id, delay);
        }
        const { actions } = scheduler;
        if (id != null && actions[actions.length - 1]?.id !== id) {
            animationFrameProvider_js_1.animationFrameProvider.cancelAnimationFrame(id);
            scheduler._scheduled = undefined;
        }
        return undefined;
    }
}
exports.AnimationFrameAction = AnimationFrameAction;//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/rxjs/dist/cjs/internal/scheduler/AnimationFrameAction.js.map