import { context } from '@opentelemetry/api';
import { getScopesFromContext } from '@sentry/opentelemetry';

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = getScopesFromContext(context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

export { setIsolationScope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/@sentry/node-core/build/esm/sdk/scope.js.map
