import { Observable, operate, COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../Observable.js';
export function materialize() {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => {
                destination.next(nextNotification(value));
            },
            error: (error) => {
                destination.next(errorNotification(error));
                destination.complete();
            },
            complete: () => {
                destination.next(COMPLETE_NOTIFICATION);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/da7d015bb36ac403cb47ce878bffd5d7bc735e40/node_modules/rxjs/dist/esm/internal/operators/materialize.js.map