import { base58btc } from './bases/base58.js';
export async function walk({ cid, load, seen }) {
    seen = seen ?? new Set();
    const b58Cid = cid.toString(base58btc);
    if (seen.has(b58Cid)) {
        return;
    }
    const block = await load(cid);
    seen.add(b58Cid);
    if (block === null) { // the loader signals with `null` that we should skip this block
        return;
    }
    for (const [, cid] of block.links()) {
        await walk({ cid, load, seen });
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/d44e0b8c64929a5174b4bc2b1cb43f1440bac1c0/node_modules/multiformats/dist/src/traversal.js.map