"use client";

// src/useIsFetching.ts
import * as React from "react";
import { notifyManager } from "@tanstack/query-core";
import { useQueryClient } from "./QueryClientProvider.js";
function useIsFetching(filters, queryClient) {
  const client = useQueryClient(queryClient);
  const queryCache = client.getQueryCache();
  return React.useSyncExternalStore(
    React.useCallback(
      (onStoreChange) => queryCache.subscribe(notifyManager.batchCalls(onStoreChange)),
      [queryCache]
    ),
    () => client.isFetching(filters),
    () => client.isFetching(filters)
  );
}
export {
  useIsFetching
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/d44e0b8c64929a5174b4bc2b1cb43f1440bac1c0/node_modules/@tanstack/react-query/build/modern/useIsFetching.js.map