import { defineIntegration, forEachEnvelopeItem } from '@sentry/core';
import { app } from 'electron';
import { normaliseProfile, normalizePaths } from '../normalize.js';

const normalizePathsIntegration = defineIntegration(() => {
    return {
        name: 'NormalizePaths',
        setup: (client) => {
            // We want this hook to be registered after the profiling-node hook so we can normalise the profile after it's
            // been attached
            setImmediate(() => {
                client.on('beforeEnvelope', (envelope) => {
                    forEachEnvelopeItem(envelope, (item, type) => {
                        if (type === 'profile') {
                            normaliseProfile(item[1], app.getAppPath());
                        }
                    });
                });
            });
        },
        processEvent(event) {
            return normalizePaths(event, app.getAppPath());
        },
    };
});

export { normalizePathsIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/d44e0b8c64929a5174b4bc2b1cb43f1440bac1c0/node_modules/@sentry/electron/esm/main/integrations/normalize-paths.js.map
