Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const carrier = require('./carrier.js');
const scope = require('./scope.js');

/** Get the default current scope. */
function getDefaultCurrentScope() {
  return carrier.getGlobalSingleton('defaultCurrentScope', () => new scope.Scope());
}

/** Get the default isolation scope. */
function getDefaultIsolationScope() {
  return carrier.getGlobalSingleton('defaultIsolationScope', () => new scope.Scope());
}

exports.getDefaultCurrentScope = getDefaultCurrentScope;
exports.getDefaultIsolationScope = getDefaultIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/d44e0b8c64929a5174b4bc2b1cb43f1440bac1c0/node_modules/@sentry/core/build/cjs/defaultScopes.js.map
