/* global crypto */
import { from } from './hasher.js';
function sha(name) {
    return async (data) => new Uint8Array(await crypto.subtle.digest(name, data));
}
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: sha('SHA-256')
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: sha('SHA-512')
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/d44e0b8c64929a5174b4bc2b1cb43f1440bac1c0/node_modules/multiformats/dist/src/hashes/sha2-browser.js.map