import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function skipUntil(notifier) {
    return (source) => new Observable((destination) => {
        let taking = false;
        const skipSubscriber = operate({
            destination,
            next: () => {
                skipSubscriber?.unsubscribe();
                taking = true;
            },
            complete: noop,
        });
        from(notifier).subscribe(skipSubscriber);
        source.subscribe(operate({ destination, next: (value) => taking && destination.next(value) }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/d1289018cc3fcc395487f65455e31651734308d0/node_modules/rxjs/dist/esm/internal/operators/skipUntil.js.map