import { getIsolationScope, getCurrentScope, getGlobalScope, mergeScopeData } from '@sentry/core';

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = getGlobalScope().getScopeData();
    const isolationScope = getIsolationScope().getScopeData();
    const currentScope = getCurrentScope().getScopeData();
    mergeScopeData(globalScope, isolationScope);
    mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

export { addScopeListener, getScopeData };//# sourceMappingURL=http://go/sourcemap/sourcemaps/d1289018cc3fcc395487f65455e31651734308d0/node_modules/@sentry/electron/esm/common/scope.js.map
