import { defineIntegration } from '@sentry/core';
import { getIPC } from '../ipc.js';

const eventLoopBlockIntegration = defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup(client) {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc = getIPC(client);
            // eslint-disable-next-line no-restricted-globals
            ipc.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

export { eventLoopBlockIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/cf858ca030e9c9a99ea444ec6efcbcfc40bfda70/node_modules/@sentry/electron/esm/renderer/integrations/event-loop-block.js.map
