import { executeSchedule } from '../util/executeSchedule.js';
import { Observable, operate } from '../Observable.js';
export function observeOn(scheduler, delay = 0) {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => executeSchedule(destination, scheduler, () => destination.next(value), delay),
            error: (err) => executeSchedule(destination, scheduler, () => destination.error(err), delay),
            complete: () => executeSchedule(destination, scheduler, () => destination.complete(), delay),
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/cf8353edc265f5e46b798bfb276861d0bf3bf120/node_modules/rxjs/dist/esm/internal/operators/observeOn.js.map