const core = require('@sentry/core');
const electron = require('electron');

function gpuDeviceToGpuContext(device) {
    return {
        name: device.deviceString || 'GPU',
        active: device.active,
        id: `0x${device.deviceId.toString(16).padStart(4, '0')}`,
        vendor_id: `0x${device.vendorId.toString(16).padStart(4, '0')}`,
        vendor_name: device.vendorString,
        driver_version: device.driverVersion,
    };
}
/**
 * Adds GPU context to events
 */
const gpuContextIntegration = core.defineIntegration((options = { infoLevel: 'basic' }) => {
    let gpuContexts;
    return {
        name: 'GpuContext',
        processEvent: async (event) => {
            if (gpuContexts === undefined) {
                const result = (await electron.app.getGPUInfo(options.infoLevel));
                gpuContexts = result.gpuDevice.map(gpuDeviceToGpuContext);
            }
            if (gpuContexts.length === 1) {
                event.contexts = { ...event.contexts, gpu: gpuContexts[0] };
            }
            else if (gpuContexts.length > 1) {
                event.contexts = { ...event.contexts };
                for (let i = 0; i < gpuContexts.length; i++) {
                    const gpuContext = gpuContexts[i];
                    gpuContext.type = 'gpu';
                    event.contexts[`gpu_${i + 1}`] = gpuContext;
                }
            }
            return event;
        },
    };
});

exports.gpuContextIntegration = gpuContextIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/cf8353edc265f5e46b798bfb276861d0bf3bf120/node_modules/@sentry/electron/main/integrations/gpu-context.js.map
