"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const Observable_js_1 = require("../Observable.js");
function every(predicate, thisArg) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}
exports.every = every;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/cjs/internal/operators/every.js.map