import { Observable, operate } from '../Observable.js';
export function defaultIfEmpty(defaultValue) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/c7365150b3b3d35fd5f6504a5686fb9ea5eea3b0/node_modules/rxjs/dist/esm/internal/operators/defaultIfEmpty.js.map