import { chromeStackLineParser } from '@sentry/browser';
import { nodeStackLineParser, stripSentryFramesAndReverse } from '@sentry/core';

const STACKTRACE_FRAME_LIMIT = 50;
const [, chrome] = chromeStackLineParser;
const [, node] = nodeStackLineParser();
/**
 * A stack parser than combines Chrome and node.js parsers to give the best results even when nodeIntegration = true
 */
const electronRendererStackParser = (stack, skipFirst = 0) => {
    const frames = [];
    for (const line of stack.split('\n').slice(skipFirst)) {
        const chromeFrame = chrome(line);
        const nodeFrame = node(line);
        // We favour the chrome parser unless in_app == false
        if (chromeFrame && nodeFrame?.in_app !== false) {
            frames.push(chromeFrame);
        }
        else if (nodeFrame) {
            if (nodeFrame.module === undefined) {
                delete nodeFrame.module;
            }
            frames.push(nodeFrame);
        }
        if (frames.length >= STACKTRACE_FRAME_LIMIT) {
            break;
        }
    }
    return stripSentryFramesAndReverse(frames);
};

export { electronRendererStackParser };//# sourceMappingURL=http://go/sourcemap/sourcemaps/c7365150b3b3d35fd5f6504a5686fb9ea5eea3b0/node_modules/@sentry/electron/esm/renderer/stack-parse.js.map
