"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeScan = void 0;
const Observable_js_1 = require("../Observable.js");
const mergeInternals_js_1 = require("./mergeInternals.js");
function mergeScan(accumulator, seed, concurrent = Infinity) {
    return (source) => new Observable_js_1.Observable((subscriber) => {
        let state = seed;
        return (0, mergeInternals_js_1.mergeInternals)(source, subscriber, (value, index) => accumulator(state, value, index), concurrent, (value) => {
            state = value;
        }, false, undefined, () => (state = null));
    });
}
exports.mergeScan = mergeScan;//# sourceMappingURL=http://go/sourcemap/sourcemaps/c7365150b3b3d35fd5f6504a5686fb9ea5eea3b0/node_modules/rxjs/dist/cjs/internal/operators/mergeScan.js.map