export const intervalProvider = {
    setInterval(handler, timeout, ...args) {
        const { delegate } = intervalProvider;
        if (delegate?.setInterval) {
            return delegate.setInterval(handler, timeout, ...args);
        }
        return setInterval(handler, timeout, ...args);
    },
    clearInterval(handle) {
        const { delegate } = intervalProvider;
        return (delegate?.clearInterval || clearInterval)(handle);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/c68681c13bdb0dea7fb85526bcc3202d20233fa0/node_modules/rxjs/dist/esm/internal/scheduler/intervalProvider.js.map