import { defineIntegration, forEachEnvelopeItem } from '@sentry/core';
import { app } from 'electron';
import { normalizePaths, normaliseProfile } from '../normalize.js';

const normalizePathsIntegration = defineIntegration(() => {
    return {
        name: 'NormalizePaths',
        setup: (client) => {
            // We want this hook to be registered after the profiling-node hook so we can normalise the profile after it's
            // been attached
            setImmediate(() => {
                client.on('beforeEnvelope', (envelope) => {
                    forEachEnvelopeItem(envelope, (item, type) => {
                        if (type === 'profile') {
                            normaliseProfile(item[1], app.getAppPath());
                        }
                    });
                });
            });
        },
        processEvent(event) {
            return normalizePaths(event, app.getAppPath());
        },
    };
});

export { normalizePathsIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/c68681c13bdb0dea7fb85526bcc3202d20233fa0/node_modules/@sentry/electron/esm/main/integrations/normalize-paths.js.map
