import { Observable, from, operate } from '../Observable.js';
export function switchMap(project) {
    return (source) => new Observable((destination) => {
        let innerSubscriber = null;
        let index = 0;
        let isComplete = false;
        const checkComplete = () => isComplete && !innerSubscriber && destination.complete();
        source.subscribe(operate({
            destination,
            next: (value) => {
                innerSubscriber?.unsubscribe();
                const outerIndex = index++;
                from(project(value, outerIndex)).subscribe((innerSubscriber = operate({
                    destination,
                    complete: () => {
                        innerSubscriber = null;
                        checkComplete();
                    },
                })));
            },
            complete: () => {
                isComplete = true;
                checkComplete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/c25eb90df95d64f6d280779237c1ca39f9f3eef0/node_modules/rxjs/dist/esm/internal/operators/switchMap.js.map