"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connect = void 0;
const Observable_js_1 = require("../Observable.js");
const Subject_js_1 = require("../Subject.js");
const fromSubscribable_js_1 = require("../observable/fromSubscribable.js");
const DEFAULT_CONFIG = {
    connector: () => new Subject_js_1.Subject(),
};
function connect(selector, config = DEFAULT_CONFIG) {
    const { connector } = config;
    return (source) => new Observable_js_1.Observable((subscriber) => {
        const subject = connector();
        (0, Observable_js_1.from)(selector((0, fromSubscribable_js_1.fromSubscribable)(subject))).subscribe(subscriber);
        subscriber.add(source.subscribe(subject));
    });
}
exports.connect = connect;//# sourceMappingURL=http://go/sourcemap/sourcemaps/c25eb90df95d64f6d280779237c1ca39f9f3eef0/node_modules/rxjs/dist/cjs/internal/operators/connect.js.map