"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEvent = void 0;
const Observable_js_1 = require("../Observable.js");
const mapOneOrManyArgs_js_1 = require("../util/mapOneOrManyArgs.js");
const nodeEventEmitterMethods = ['addListener', 'removeListener'];
const eventTargetMethods = ['addEventListener', 'removeEventListener'];
const jqueryMethods = ['on', 'off'];
function fromEvent(target, eventName, options, resultSelector) {
    if ((0, Observable_js_1.isFunction)(options)) {
        resultSelector = options;
        options = undefined;
    }
    if (resultSelector) {
        return (0, mapOneOrManyArgs_js_1.mapOneOrManyArgs)(resultSelector)(fromEvent(target, eventName, options));
    }
    const isValidTarget = isNodeStyleEventEmitter(target) || isJQueryStyleEventEmitter(target) || isEventTarget(target);
    if (!isValidTarget && !(0, Observable_js_1.isArrayLike)(target)) {
        throw new TypeError('Invalid event target');
    }
    return new Observable_js_1.Observable((subscriber) => {
        const handler = (...args) => subscriber.next(1 < args.length ? args : args[0]);
        if (isValidTarget) {
            doSubscribe(handler, subscriber, target, eventName, options);
        }
        else {
            for (let i = 0; i < target.length && !subscriber.closed; i++) {
                const subTarget = target[i];
                doSubscribe(handler, subscriber, subTarget, eventName, options);
            }
        }
    });
}
exports.fromEvent = fromEvent;
function doSubscribe(handler, subscriber, subTarget, eventName, options) {
    const [addMethod, removeMethod] = getRegistryMethodNames(subTarget);
    if (!addMethod || !removeMethod) {
        throw new TypeError('Invalid event target');
    }
    subTarget[addMethod](eventName, handler, options);
    subscriber.add(() => subTarget[removeMethod](eventName, handler, options));
}
function getRegistryMethodNames(target) {
    return isEventTarget(target)
        ? eventTargetMethods
        :
            isNodeStyleEventEmitter(target)
                ? nodeEventEmitterMethods
                : isJQueryStyleEventEmitter(target)
                    ? jqueryMethods
                    : [];
}
function isNodeStyleEventEmitter(target) {
    return (0, Observable_js_1.isFunction)(target.addListener) && (0, Observable_js_1.isFunction)(target.removeListener);
}
function isJQueryStyleEventEmitter(target) {
    return (0, Observable_js_1.isFunction)(target.on) && (0, Observable_js_1.isFunction)(target.off);
}
function isEventTarget(target) {
    return (0, Observable_js_1.isFunction)(target.addEventListener) && (0, Observable_js_1.isFunction)(target.removeEventListener);
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/c25eb90df95d64f6d280779237c1ca39f9f3eef0/node_modules/rxjs/dist/cjs/internal/observable/fromEvent.js.map