import { context } from '@opentelemetry/api';
import { getScopesFromContext } from '@sentry/opentelemetry';

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = getScopesFromContext(context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

export { setIsolationScope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/c25eb90df95d64f6d280779237c1ca39f9f3eef0/node_modules/@sentry/node-core/build/esm/sdk/scope.js.map
