import { concat } from '../observable/concat.js';
import { take } from './take.js';
import { ignoreElements } from './ignoreElements.js';
import { mergeMap } from './mergeMap.js';
import { rx } from '../util/rx.js';
import { map } from './map.js';
export function delayWhen(delayDurationSelector, subscriptionDelay) {
    if (subscriptionDelay) {
        return (source) => concat(rx(subscriptionDelay, take(1), ignoreElements()), rx(source, delayWhen(delayDurationSelector)));
    }
    return mergeMap((value, index) => rx(delayDurationSelector(value, index), take(1), map(() => value)));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/c25eb90df95d64f6d280779237c1ca39f9f3eef0/node_modules/rxjs/dist/esm/internal/operators/delayWhen.js.map